package ru.yandex.direct.intapi.entity.clients.model;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.currency.CurrencyCode;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class ClientInfo {

    @JsonProperty("client_id")
    private Long clientId;
    private String name;
    private String role;
    @JsonProperty("has_contract")
    private Boolean hasContract;
    @JsonProperty("currency_code")
    private CurrencyCode currencyCode;
    @JsonProperty("balance")
    private BigDecimal balance;
    @JsonProperty("nds")
    private BigDecimal nds;
    @JsonProperty("country_region_id")
    private Long countryRegionId;

    public Long getClientId() {
        return clientId;
    }

    public ClientInfo withClientId(final Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getName() {
        return name;
    }

    public ClientInfo withName(final String name) {
        this.name = name;
        return this;
    }

    public String getRole() {
        return role;
    }

    public ClientInfo withRole(final String role) {
        this.role = role;
        return this;
    }

    public Boolean isHasContract() {
        return hasContract;
    }

    public ClientInfo withHasContract(final Boolean hasContract) {
        this.hasContract = hasContract;
        return this;
    }

    public CurrencyCode getCurrencyCode() {
        return currencyCode;
    }

    public ClientInfo withCurrencyCode(final CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public ClientInfo withBalance(BigDecimal balance) {
        this.balance = balance;
        return this;
    }

    public BigDecimal getNds() {
        return nds;
    }

    public ClientInfo withNds(BigDecimal nds) {
        this.nds = nds;
        return this;
    }

    public Long getCountryRegionId() {
        return countryRegionId;
    }

    public ClientInfo withCountryRegionId(Long countryRegionId) {
        this.countryRegionId = countryRegionId;
        return this;
    }
}
