package ru.yandex.direct.intapi.entity.clients.model;

import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.checkerframework.checker.nullness.qual.NonNull;

import ru.yandex.direct.currency.CurrencyCode;

import static ru.yandex.direct.utils.CommonUtils.nvl;

public class ClientsAddOrGetRequest {
    @JsonProperty("login")
    @Nullable
    private final String login;

    @JsonProperty("uid")
    @Nullable
    private final Long uid;

    @JsonProperty("fio")
    @Nonnull
    private final String fio;

    @JsonProperty("country")
    private final int country;

    @JsonProperty("currency")
    @Nonnull
    private final CurrencyCode currency;

    @JsonProperty("with_api")
    @Nullable
    private final Boolean withApi;

    @JsonCreator
    public ClientsAddOrGetRequest(
            @Nullable @JsonProperty("login") String login,
            @Nullable @JsonProperty("uid") Long uid,
            @NonNull @JsonProperty("fio") String fio,
            @JsonProperty("country") int country,
            @NonNull @JsonProperty("currency") CurrencyCode currency,
            @Nullable @JsonProperty("with_api") Boolean withApi) {
        this.login = login;
        this.uid = uid;
        this.fio = fio;
        this.country = country;
        this.currency = currency;
        this.withApi = withApi;
    }

    @Nullable
    public String getLogin() {
        return login;
    }

    public int getCountry() {
        return country;
    }

    @Nonnull
    public String getFio() {
        return fio;
    }

    @NonNull
    public CurrencyCode getCurrency() {
        return currency;
    }

    @Nullable
    public Long getUid() {
        return uid;
    }

    @Nullable
    public Boolean isWithApi() {
        return withApi;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ClientsAddOrGetRequest that = (ClientsAddOrGetRequest) o;

        if (country != that.country) {
            return false;
        }
        if (!Objects.equals(login, that.login)) {
            return false;
        }
        if (!Objects.equals(uid, that.uid)) {
            return false;
        }
        if (!fio.equals(that.fio)) {
            return false;
        }
        if (!currency.equals(that.currency)) {
            return false;
        }
        return Objects.equals(withApi, that.withApi);
    }

    @Override
    public int hashCode() {
        int result = login != null ? login.hashCode() : 0;
        result = 31 * result + (uid != null ? uid.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ClientsAddOrGetRequest{" +
                "login='" + nvl(login, "") + '\'' +
                ", uid=" + nvl(uid, "") +
                ", fio='" + fio + '\'' +
                ", country=" + country +
                ", currency=" + currency +
                ", with_api=" + nvl(withApi, true) +
                '}';
    }
}
