package ru.yandex.direct.intapi.entity.clients.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.core.model.WebSuccessResponse;

/**
 * Модель ответа для clients/addOrGet.
 * Возвращает clientId, uid, финансовый токен и основной логин пользователя.
 */
public class ClientsAddOrGetResponse extends WebSuccessResponse {
    @JsonProperty("client_id")
    private final long clientId;
    @JsonProperty("user_id")
    private final long userId;
    @JsonProperty("finance_token")
    private final String financeToken;
    @JsonProperty("login")
    private final String login;

    public ClientsAddOrGetResponse(long clientId, long userId, String financeToken, String login) {
        this.clientId = clientId;
        this.userId = userId;
        this.financeToken = financeToken;
        this.login = login;
    }

    public long getClientId() {
        return clientId;
    }

    public long getUserId() {
        return userId;
    }

    public String getFinanceToken() {
        return financeToken;
    }

    public String getLogin() {
        return login;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ClientsAddOrGetResponse that = (ClientsAddOrGetResponse) o;

        if (clientId != that.clientId) {
            return false;
        }
        if (userId != that.userId) {
            return false;
        }
        return Objects.equals(login, that.login);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, userId, login);
    }

    @Override
    public String toString() {
        return "ClientsAddResponse{" +
                "clientId=" + clientId +
                ", userId=" + userId +
                ", login='" + login + '\'' +
                '}';
    }
}
