package ru.yandex.direct.intapi.entity.clients.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.intapi.entity.display.canvas.model.Privileges;
import ru.yandex.direct.rbac.model.RbacAccessType;

@ParametersAreNonnullByDefault
public class OperatorPermissions {

    private Set<Permission> permissions;

    private OperatorPermissions(Set<Permission> permissions) {
        this.permissions = Collections.unmodifiableSet(permissions);
    }

    public Set<Permission> getPermissions() {
        return permissions;
    }

    public static class Builder {

        private Set<Permission> permissions;

        public Builder() {
            permissions = new HashSet<>();
        }

        public OperatorPermissions build() {
            return new OperatorPermissions(permissions);
        }

        public Builder addPermission(Permission permission) {
            permissions.add(permission);
            return this;
        }
    }

    @JsonSerialize(using = Privileges.LowerCaseSerializer.class)
    public enum Permission {

        ORG_READ,
        ORG_WRITE;

        public static Set<Permission> ofRbacAccessType(RbacAccessType rbacAccessType) {
            switch (rbacAccessType) {
                case READ_WRITE:
                    return ImmutableSet.of(ORG_READ, ORG_WRITE);
                case READONLY:
                    return ImmutableSet.of(ORG_READ);
                default:
                    return ImmutableSet.of();
            }
        }
    }
}
