package ru.yandex.direct.intapi.entity.connect.converter;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.client.model.Client;
import ru.yandex.direct.intapi.entity.connect.model.GetRolesResponseItem;

import static ru.yandex.direct.dbutil.model.ClientId.fromLong;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmRoles.ASSOCIATED;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmRoles.CHIEF;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmRoles.EMPLOYEE;

@ParametersAreNonnullByDefault
public class ConnectIdmRolesResponseConverter {

    private ConnectIdmRolesResponseConverter() {
    }

    public static GetRolesResponseItem toChiefItem(Client client) {
        return GetRolesResponseItem
                .getBuilder(CHIEF, client.getConnectOrgId(), fromLong(client.getClientId()), client.getChiefUid())
                .build();
    }

    public static GetRolesResponseItem toEmployeeItem(Client client, Long uid) {
        return GetRolesResponseItem
                .getBuilder(EMPLOYEE, client.getConnectOrgId(), fromLong(client.getClientId()), uid)
                .build();
    }

    public static GetRolesResponseItem toAssociatedItem(Client client) {
        return GetRolesResponseItem
                .getBuilder(ASSOCIATED, client.getConnectOrgId(), fromLong(client.getClientId()),
                        client.getConnectOrgId())
                .build();
    }

}
