package ru.yandex.direct.intapi.entity.connect.model;

/**
 * Все ошибки соответствуют этой таблице: https://nda.ya.ru/3Vsgmy
 *
 * Все изменения нужно согласовывать с коммандой Connect'а и синхронизировать в вышеуказанной таблице.
 */
public enum ConnectError {
    NO_RESOURCE_ID(110, "absent fields.resource_id"),
    NO_SUBJECT_TYPE(120, "absent subject_type"),
    SUBJECT_TYPE_AND_ROLE_MISSMATCH(125, "subject_type is incompatible with given role"),
    NO_PATH(130, "absent path"),
    WRONG_PATH(140, "wrong path"),
    NO_ID(150, "absent id"),
    NO_ORG_ID(160, "absent org_id"),
    RESOURCE_NOT_FOUND(210, "resource not found"),
    RESOURCE_NOT_ASSOCIATED(220, "resource not associated"),
    RESOURCE_HAS_NO_CLIENT_ROLE(230, "resource has no client role"),
    RESOURCE_CANNOT_BE_FREELANCER(240, "resource cannot be freelancer"),
    ID_ASSOCIATED_TO_ANOTHER_RESOURCE(320, "id associated to another resource"),
    USER_ASSOCIATED_TO_ANOTHER_RESOURCE(330, "user associated to another resource"),
    USER_ASSOCIATED_TO_ANOTHER_BALANCE_CLIENT(340, "user associated to another balance client"),
    USER_CANNOT_BE_CHIEF(350, "user cannot be chief"),
    USER_HAS_ACTIVE_AUTOPAY(360, "user has active autopay"),
    USER_HAS_CHARGE_CARD(370, "user has charge card"),
    USER_HAS_NOT_VALID_NAME(380, "user has not valid name"),
    USER_HAS_NOT_VALID_EMAIL(390, "user has not valid email"),
    CLIENT_NOT_FOUND_IN_BALANCE(420, "client not found in Balance"),
    GENERAL_ERROR(555, "error while request processing");

    private final int code;
    private final String message;

    ConnectError(int code, String message) {
        this.code = code;
        this.message = message;

    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
