package ru.yandex.direct.intapi.entity.connect.model;


import java.util.Map;
import java.util.function.Function;

import one.util.streamex.StreamEx;

import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.ORGANIZATION_SLUG;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.ROLE_SLUG;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.SERVICE_SLUG;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.USER_SLUG;


public enum ConnectIdmRoles {
    CHIEF(USER_SLUG, "chief", "основной представитель"),
    EMPLOYEE(USER_SLUG, "employee", "представитель"),
    ASSOCIATED(ORGANIZATION_SLUG, "associated", "привязанная");

    private static final Map<String, ConnectIdmRoles> ROLE_BY_PATH = StreamEx.of(ConnectIdmRoles.values())
            .toMap(ConnectIdmRoles::getRolePath, Function.identity());

    private final String rolePath;
    private final String subjectType;
    private final String roleName;
    private final String roleDescription;

    ConnectIdmRoles(String subjectType, String roleName, String roleDescription) {
        this.subjectType = subjectType;
        this.roleName = roleName;
        this.roleDescription = roleDescription;

        this.rolePath = String.format("/%s/%s/%s/%s/", SERVICE_SLUG, subjectType, ROLE_SLUG, roleName);
    }

    public String getRolePath() {
        return rolePath;
    }

    public String getSubjectType() {
        return subjectType;
    }

    public String getRoleName() {
        return roleName;
    }

    public String getRoleDescription() {
        return roleDescription;
    }

    @SuppressWarnings("BooleanMethodIsAlwaysInverted")
    public static boolean isPathValid(String path) {
        return ROLE_BY_PATH.containsKey(path);
    }

    public static ConnectIdmRoles getRoleByPath(String path) {
        return ROLE_BY_PATH.get(path);

    }
}
