package ru.yandex.direct.intapi.entity.connect.model;

import java.util.Map;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.collections4.CollectionUtils;

import ru.yandex.direct.result.Result;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;

import static java.util.Map.entry;
import static ru.yandex.direct.core.entity.user.service.validation.UserDefects.balanceUserAssociatedWithAnotherClient;
import static ru.yandex.direct.core.entity.user.service.validation.UserDefects.chiefDeletionProhibited;
import static ru.yandex.direct.core.entity.user.service.validation.UserDefects.userHasActiveAutoPay;
import static ru.yandex.direct.core.entity.user.service.validation.UserDefects.userHasCardPaymentMethod;
import static ru.yandex.direct.core.entity.user.service.validation.UserDefects.userHasNotValidEmail;
import static ru.yandex.direct.core.entity.user.service.validation.UserDefects.userHasNotValidName;
import static ru.yandex.direct.core.entity.user.service.validation.UserDefects.userNotFound;

@ParametersAreNonnullByDefault
public class DefectConvertor {

    private static final Map<Defect, ConnectError> DEFECT_TO_ERROR_MAP = Map.ofEntries(
            entry(chiefDeletionProhibited(), ConnectError.USER_CANNOT_BE_CHIEF),
            entry(userNotFound(), ConnectError.RESOURCE_NOT_FOUND),
            entry(balanceUserAssociatedWithAnotherClient(), ConnectError.USER_ASSOCIATED_TO_ANOTHER_BALANCE_CLIENT),
            entry(userHasActiveAutoPay(), ConnectError.USER_HAS_ACTIVE_AUTOPAY),
            entry(userHasCardPaymentMethod(), ConnectError.USER_HAS_CHARGE_CARD),
            entry(userHasNotValidName(), ConnectError.USER_HAS_NOT_VALID_NAME),
            entry(userHasNotValidEmail(), ConnectError.USER_HAS_NOT_VALID_EMAIL)
    );

    private DefectConvertor() {
    }

    public static ConnectError mapDefectsToErrorCode(Result<?> vr) {
        return Optional.of(vr)
                .map(Result::getErrors)
                .filter(CollectionUtils::isNotEmpty)
                .map(es -> es.get(0))
                .map(DefectInfo::getDefect)
                .map(DEFECT_TO_ERROR_MAP::get)
                .orElse(ConnectError.GENERAL_ERROR);
    }

}
