package ru.yandex.direct.intapi.entity.connect.model;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

import ru.yandex.direct.dbutil.model.ClientId;

import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.RESOURCE_ID;

public class GetRolesResponseItem {
    private String path;
    private Long id;
    private Long connectOrgId;
    private Map<String, String> fields;
    private String subjectType;

    private GetRolesResponseItem() {
    }

    public static Builder getBuilder(ConnectIdmRoles role, Long connectOrgId, ClientId clientId, Long id) {
        return new Builder(role, connectOrgId, clientId, id);
    }

    @JsonProperty("path")
    public String getPath() {
        return path;
    }

    @JsonProperty("id")
    @JsonSerialize(using = ToStringSerializer.class)
    public Long getId() {
        return id;
    }

    @JsonProperty("org_id")
    @JsonSerialize(using = ToStringSerializer.class)
    public Long getConnectOrgId() {
        return connectOrgId;
    }

    @JsonProperty("fields")
    public Map<String, String> getFields() {
        return fields;
    }

    @JsonProperty("subject_type")
    public String getSubjectType() {
        return subjectType;
    }

    public static class Builder {
        private final ConnectIdmRoles role;
        private final Long id;
        private final Long connectOrgId;
        private final ClientId clientId;

        public Builder(ConnectIdmRoles role, Long connectOrgId, ClientId clientId, Long id) {
            this.role = role;
            this.id = id;
            this.connectOrgId = connectOrgId;
            this.clientId = clientId;
        }

        public GetRolesResponseItem build() {
            GetRolesResponseItem item = new GetRolesResponseItem();
            item.path = role.getRolePath();
            item.connectOrgId = connectOrgId;
            item.id = id;
            item.fields = Map.of(RESOURCE_ID, clientId.toString());
            item.subjectType = role.getSubjectType();
            return item;
        }
    }

}
