package ru.yandex.direct.intapi.entity.connect.model;

import com.fasterxml.jackson.annotation.JsonGetter;

import static java.util.Objects.requireNonNull;


public class IdmErrorResponse implements IdmResponse {
    private final int code;
    private final String error;

    public IdmErrorResponse(ConnectError connectError) {
        this(connectError.getCode(), connectError.getMessage());
    }

    public IdmErrorResponse(String error) {
        this(1, error);
    }

    private IdmErrorResponse(int code, String error) {
        this.code = code;
        this.error = requireNonNull(error);
    }

    @JsonGetter("error")
    public String getError() {
        return error;
    }

    @Override
    public Integer getCode() {
        return code;
    }
}
