package ru.yandex.direct.intapi.entity.connect.model;

import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;

public class InfoResponseSubRoles extends InfoResponseRolesBase {

    private Set<ConnectIdmRoles> values;

    public Set<ConnectIdmRoles> getValues() {
        return values;
    }

    public void setValues(Set<ConnectIdmRoles> values) {
        this.values = values;
    }

    @JsonGetter("values")
    public Map<String, String> getStringValues() {
        return StreamEx.of(values)
                .mapToEntry(ConnectIdmRoles::getRoleName, ConnectIdmRoles::getRoleDescription)
                .toMap();
    }

    @JsonSetter("values")
    public void setStringValues(Map<String, String> roles) {
        this.values = EntryStream.of(roles).map(this::findRole).toSet();
    }

    private ConnectIdmRoles findRole(Map.Entry<String, String> role) {
        return StreamEx.of(ConnectIdmRoles.values())
                .filter(r -> r.getRoleName().equals(role.getKey()) && r.getRoleDescription().equals(role.getValue()))
                .findFirst()
                .get();
    }
}
