package ru.yandex.direct.intapi.entity.connect.model;

import java.util.Map;
import java.util.function.Function;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import one.util.streamex.StreamEx;

import static com.google.common.base.Preconditions.checkNotNull;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.ORGANIZATION_SLUG;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.USER_SLUG;

public enum SubjectType {
    USER(USER_SLUG),
    ORGANIZATION(ORGANIZATION_SLUG);

    private final String slug;

    private static final Map<String, SubjectType> TYPE_BY_NAME =
            StreamEx.of(SubjectType.values())
                    .mapToEntry(SubjectType::toString, Function.identity())
                    .toImmutableMap();

    SubjectType(String slug) {
        this.slug = slug;
    }

    @JsonCreator
    public static SubjectType fromString(String s) {
        return checkNotNull(TYPE_BY_NAME.get(s), "Unexpected subjectType: %s", s);
    }

    @JsonValue
    public String toString() {
        return this.slug;
    }
}
