package ru.yandex.direct.intapi.entity.connect.service;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.intapi.entity.connect.model.ConnectIdmRoles;
import ru.yandex.direct.intapi.entity.connect.model.InfoResponse;
import ru.yandex.direct.intapi.entity.connect.model.InfoResponseField;
import ru.yandex.direct.intapi.entity.connect.model.InfoResponseRoles;
import ru.yandex.direct.intapi.entity.connect.model.InfoResponseRolesGroup;
import ru.yandex.direct.intapi.entity.connect.model.InfoResponseSubRoles;

import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.ORGANIZATION_NAME;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.ORGANIZATION_SLUG;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.RESOURCE_ID;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.RESOURCE_ID_NAME;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.ROLE_NAME;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.ROLE_SLUG;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.SERVICE_NAME;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.SERVICE_SLUG;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.TYPE_CHARFIELD;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.USER_NAME;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmConstants.USER_SLUG;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmRoles.ASSOCIATED;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmRoles.CHIEF;
import static ru.yandex.direct.intapi.entity.connect.model.ConnectIdmRoles.EMPLOYEE;

@Service
@ParametersAreNonnullByDefault
public class ConnectIdmInfoService {

    public InfoResponse getInfo() {
        return new InfoResponse().withFields(
                makeFields()
        ).withRoles(
                makeRoles()
        );
    }

    private List<InfoResponseField> makeFields() {
        return Collections.singletonList(new InfoResponseField()
                .withName(RESOURCE_ID_NAME)
                .withSlug(RESOURCE_ID)
                .withType(TYPE_CHARFIELD)
                .withRequired(true)
        );
    }

    private InfoResponseRoles makeRoles() {
        final InfoResponseRoles roles = new InfoResponseRoles();
        roles.setName(SERVICE_NAME);
        roles.setSlug(SERVICE_SLUG);
        roles.setValues(Map.of(
                USER_SLUG, makeRolesGroup(USER_NAME, Set.of(EMPLOYEE, CHIEF)),
                ORGANIZATION_SLUG, makeRolesGroup(ORGANIZATION_NAME, Set.of(ASSOCIATED))
        ));

        return roles;
    }

    private InfoResponseRolesGroup makeRolesGroup(String name, Set<ConnectIdmRoles> roles) {
        InfoResponseRolesGroup group = new InfoResponseRolesGroup();
        group.setName(name);
        group.setRoles(makeSubRolesItem(roles));

        return group;
    }

    private InfoResponseSubRoles makeSubRolesItem(Set<ConnectIdmRoles> roles) {
        final InfoResponseSubRoles item = new InfoResponseSubRoles();
        item.setName(ROLE_NAME);
        item.setSlug(ROLE_SLUG);
        item.setValues(roles);

        return item;
    }
}
