package ru.yandex.direct.intapi.entity.copyentity.model;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.copyentity.model.CopyCampaignFlags;

@ParametersAreNonnullByDefault
public class CopyCampaignRequest {
    @JsonProperty("operator_uid")
    private Long operatorUid;

    @JsonProperty("client_id_from")
    private Long clientIdFrom;

    @JsonProperty("client_id_to")
    private Long clientIdTo;

    @JsonProperty("campaign_ids")
    private List<Long> campaignIds;

    @JsonProperty("flags")
    private CopyCampaignFlags flags;

    @JsonProperty("generate_reports")
    private boolean generateReports;

    @JsonCreator
    public CopyCampaignRequest(@JsonProperty("operator_uid") Long operatorUid,
                               @JsonProperty("client_id_from") Long clientIdFrom,
                               @JsonProperty("client_id_to") Long clientIdTo,
                               @JsonProperty("campaign_ids") List<Long> campaignIds,
                               @JsonProperty("flags") CopyCampaignFlags flags,
                               @JsonProperty("generate_reports") boolean generateReports) {
        this.operatorUid = operatorUid;
        this.clientIdFrom = clientIdFrom;
        this.clientIdTo = clientIdTo;
        this.campaignIds = campaignIds;
        this.flags = flags;
        this.generateReports = generateReports;
    }

    public Long getOperatorUid() {
        return operatorUid;
    }

    public Long getClientIdFrom() {
        return clientIdFrom;
    }

    public Long getClientIdTo() {
        return clientIdTo;
    }

    public List<Long> getCampaignIds() {
        return campaignIds;
    }

    public CopyCampaignFlags getFlags() {
        return flags;
    }

    public boolean isGenerateReports() {
        return generateReports;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CopyCampaignRequest that = (CopyCampaignRequest) o;
        return generateReports == that.generateReports &&
                Objects.equals(operatorUid, that.operatorUid) &&
                Objects.equals(clientIdFrom, that.clientIdFrom) &&
                Objects.equals(clientIdTo, that.clientIdTo) &&
                Objects.equals(campaignIds, that.campaignIds) &&
                Objects.equals(flags, that.flags);
    }

    @Override
    public int hashCode() {
        return Objects.hash(operatorUid, clientIdFrom, clientIdTo, campaignIds, flags, generateReports);
    }

    @Override
    public String toString() {
        return "CopyCampaignRequest{" +
                "operatorUid=" + operatorUid +
                ", clientIdFrom=" + clientIdFrom +
                ", clientIdTo=" + clientIdTo +
                ", campaignIds=" + campaignIds +
                ", flags=" + flags +
                ", generateReports=" + generateReports +
                '}';
    }
}
