package ru.yandex.direct.intapi.entity.copyentity.model;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.intapi.validation.model.IntapiSuccessResponse;

@ParametersAreNonnullByDefault
public class CopyClientCampaignBulkResponse extends IntapiSuccessResponse {
    private List<Long> campaignIdsToCopy;
    private long timeEstimateMinutes;

    public CopyClientCampaignBulkResponse(List<Long> campaignIdsToCopy, long timeEstimateMinutes) {
        this.campaignIdsToCopy = campaignIdsToCopy;
        this.timeEstimateMinutes = timeEstimateMinutes;
    }

    @JsonProperty("campaign_ids_to_copy")
    public List<Long> getCampaignIdsToCopy() {
        return campaignIdsToCopy;
    }

    @JsonProperty("time_estimate_minutes")
    public long getTimeEstimateMinutes() {
        return timeEstimateMinutes;
    }
}
