package ru.yandex.direct.intapi.entity.copyentity.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.intapi.validation.model.IntapiValidationResponse;
import ru.yandex.direct.intapi.validation.model.IntapiValidationResult;

@ParametersAreNonnullByDefault
public class CopyClientCampaignResponse extends IntapiValidationResponse {
    private final Long resultCampaignId;

    public CopyClientCampaignResponse(IntapiValidationResult intapiValidationResult,
                                      @Nullable Long resultCampaignId) {
        super(intapiValidationResult);
        this.resultCampaignId = resultCampaignId;
    }

    public CopyClientCampaignResponse(IntapiValidationResponse intapiValidationResponse, Long resultCampaignId) {
        super(intapiValidationResponse.validationResult());
        this.resultCampaignId = resultCampaignId;
    }

    @Nullable
    @JsonProperty("result_id")
    public Long getResultCampaignId() {
        return resultCampaignId;
    }
}
