package ru.yandex.direct.intapi.entity.creative.presentation;

import ru.yandex.direct.core.entity.creative.service.add.validation.CreativeDefectIds;
import ru.yandex.direct.core.entity.creative.service.add.validation.CreativeDefectTranslations;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.core.entity.creative.service.add.validation.CreativeDefectIds.ClientIds.CREATIVE_NOT_BELONG_TO_CLIENT;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.paramIntapiDefect;

public class CreativeDefectPresentations {

    private CreativeDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> creativeDefectPresentationRegistry() {
        CreativeDefectTranslations translations = CreativeDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(CREATIVE_NOT_BELONG_TO_CLIENT,
                        paramIntapiDefect(di -> translations.creativeNotBelongToClient(
                                new Identity(di.getDefect().params()))))

                .register(CreativeDefectIds.AdminReject.CREATIVE_IS_ADMIN_REJECTED, defaultIntapiDefect())

                .register(CreativeDefectIds.Gen.UPLOAD_VIDEO_FAILED, defaultIntapiDefect())
                .register(CreativeDefectIds.Gen.CREATE_ADDITION_FROM_VIDEO_FAILED, defaultIntapiDefect())
                .build();
    }
}
