package ru.yandex.direct.intapi.entity.crm.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import ru.yandex.direct.dbutil.model.ClientId;

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CrmAdgroupInfo {
    @JsonProperty
    private final Long adgroupId;

    @JsonProperty
    private final ClientId clientId;

    @JsonProperty
    private final Long campaignId;

    @JsonProperty
    private final String error;

    private CrmAdgroupInfo(Long adgroupId, ClientId clientId, Long campaignId, String error) {
        this.adgroupId = adgroupId;
        this.clientId = clientId;
        this.campaignId = campaignId;
        this.error = error;
    }

    public static CrmAdgroupInfo create(Long adGroupId, ClientId clientId, Long campaignId) {
        return new CrmAdgroupInfo(adGroupId, clientId, campaignId, null);
    }

    public static CrmAdgroupInfo error(Long adGroupId, String error) {
        return new CrmAdgroupInfo(adGroupId, null, null, error);
    }

    public Long getAdgroupId() {
        return adgroupId;
    }

    public ClientId getClientId() {
        return clientId;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public String getError() {
        return error;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CrmAdgroupInfo that = (CrmAdgroupInfo) o;
        return Objects.equals(adgroupId, that.adgroupId) &&
                Objects.equals(clientId, that.clientId) &&
                Objects.equals(campaignId, that.campaignId) &&
                Objects.equals(error, that.error);
    }

    @Override
    public int hashCode() {
        return Objects.hash(adgroupId, clientId, campaignId, error);
    }
}
