package ru.yandex.direct.intapi.entity.crypta.controller;


import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.intapi.entity.crypta.model.CryptaSegmentsResponse;
import ru.yandex.direct.tvm.AllowServices;
import ru.yandex.direct.web.core.entity.inventori.service.CryptaService;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.retargeting.CryptaGoalWeb;

import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.DIRECT_WEB_PROD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_WEB_TEST;

@Controller
@RequestMapping(value = "/targets/crypta",
        produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "crypta")
@AllowServices(production = {DIRECT_WEB_PROD}, testing = {DIRECT_WEB_TEST, DIRECT_DEVELOPER})
public class CryptaController {

    private final CryptaService cryptaService;

    @Autowired
    public CryptaController(CryptaService cryptaService) {
        this.cryptaService = cryptaService;
    }

    @ApiOperation(
            value = "getCryptaSegments",
            httpMethod = "GET",
            nickname = "getCryptaSegments"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = CryptaSegmentsResponse.class)
            }
    )
    @RequestMapping(path = "/segments", method = RequestMethod.GET)
    @ResponseBody
    public CryptaSegmentsResponse getCryptaSegments(
            @ApiParam(value = "категория сегментов крипты")
            @RequestParam(value = "type", required = false) String type,
            @ApiParam(value = "строка поиска по названию сегментов")
            @RequestParam(value = "filter", required = false) String filter) {

        final List<CryptaGoalWeb> segments = cryptaService.getSegmentsIntapi().stream()
                .filter(s -> StringUtils.isEmpty(type) || type.equalsIgnoreCase(s.getType().name()))
                .filter(s -> StringUtils.isEmpty(filter) || s.getName().toLowerCase().contains(filter.toLowerCase()))
                .collect(toList());

        return new CryptaSegmentsResponse().withResult(segments);
    }

}
