package ru.yandex.direct.intapi.entity.crypta.model;

import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.web.core.model.retargeting.CryptaGoalWeb;
import ru.yandex.direct.web.core.model.retargeting.CryptaInterestTypeWeb;
import ru.yandex.direct.web.core.model.retargeting.WebGoalType;

public class CryptaSegmentConverter {
    private CryptaSegmentConverter() {
    }

    public static CryptaGoalWeb fromSegment(Goal goal) {
        return new CryptaGoalWeb()
                .withId(goal.getId())
                .withParentId(goal.getParentId())
                .withType(WebGoalType.fromCoreType(goal.getType()))
                .withInterestType(CryptaInterestTypeWeb.fromCoreType(goal.getInterestType()))
                .withName(goal.getName());
    }
}
