package ru.yandex.direct.intapi.entity.deal.presentation;

import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.core.entity.deal.service.validation.DealDefectIds.Currency.CAMPAIGN_AND_DEAL_CURRENCY_SHOULD_MATCH;
import static ru.yandex.direct.core.entity.deal.service.validation.DealDefectIds.Currency.DEAL_CURRENCY_SHOULD_MATCH_CLIENT;
import static ru.yandex.direct.core.entity.deal.service.validation.DealDefectIds.DEAL_IS_NOT_ACTIVE;
import static ru.yandex.direct.core.entity.deal.service.validation.DealDefectIds.TRANSITION_IS_UNAVAILABLE;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;

public class DealDefectPresentations {

    private DealDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> dealDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(TRANSITION_IS_UNAVAILABLE, defaultIntapiDefect())
                .register(DEAL_IS_NOT_ACTIVE, defaultIntapiDefect())
                .register(CAMPAIGN_AND_DEAL_CURRENCY_SHOULD_MATCH, defaultIntapiDefect())
                .register(DEAL_CURRENCY_SHOULD_MATCH_CLIENT, defaultIntapiDefect())
                .build();
    }
}
