package ru.yandex.direct.intapi.entity.display.canvas.model;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
public class AuthResponse {
    private final List<ActionType> availableActions;
    private final List<FeatureType> availableFeatures;

    public AuthResponse(List<ActionType> availableActions, List<FeatureType> availableFeatures) {
        this.availableActions = availableActions;
        this.availableFeatures = availableFeatures;
    }

    @ApiModelProperty(
            value = "список действий, доступных оператору для данного клиента",
            required = true
    )
    public List<ActionType> getAvailableActions() {
        return availableActions;
    }

    @ApiModelProperty(
            value = "список фич, доступных оператору для данного клиента",
            required = true
    )
    public List<FeatureType> getAvailableFeatures() {
        return availableFeatures;
    }
}
