package ru.yandex.direct.intapi.entity.display.canvas.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
public class CreativeCampaignResult {

    private Long campaignId;
    private String name;
    private String url;

    @ApiModelProperty(
            value = "id кампании",
            required = true
    )
    public Long getCampaignId() {
        return campaignId;
    }

    @ApiModelProperty(
            value = "название кампании",
            required = true
    )
    public String getName() {
        return name;
    }

    @ApiModelProperty(
            value = "url кампании",
            required = true
    )
    public String getUrl() {
        return url;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }


    public CreativeCampaignResult withUrl(String url) {
        this.url = url;
        return this;
    }

    public CreativeCampaignResult withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public CreativeCampaignResult withName(String name) {
        this.name = name;
        return this;
    }
}
