package ru.yandex.direct.intapi.entity.display.canvas.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.direct.core.entity.creative.model.AdditionalData;
import ru.yandex.direct.core.entity.creative.model.ModerationInfo;
import ru.yandex.direct.core.entity.creative.model.YabsData;


@ApiModel
public class CreativeUploadData {
    @JsonProperty("creative_id")
    private long creativeId;
    @JsonProperty("creative_type")
    private CreativeUploadType creativeType;
    @JsonProperty("creative_name")
    private String creativeName;
    @JsonProperty("preview_url")
    private String previewUrl;
    @JsonProperty("live_preview_url")
    private String livePreviewUrl;
    @JsonProperty("expanded_preview_url")
    private String expandedPreviewUrl;
    @JsonProperty("archive_url")
    private String archiveUrl;
    private Integer width;
    private Integer height;
    @JsonProperty("composed_from")
    private CreativeUploadComposedFrom composedFrom;
    @JsonProperty("stock_creative_id")
    private Long stockCreativeId;
    @JsonProperty("moderation_info")
    private ModerationInfo moderationInfo;
    @JsonProperty("yabs_data")
    private YabsData yabsData;
    @JsonProperty
    private Double duration;
    @JsonProperty("preset_id")
    private Integer presetId;
    @JsonProperty("has_packshot")
    private Boolean hasPackshot;
    @JsonProperty("is_adaptive")
    private Boolean isAdaptive;
    @JsonProperty("is_brand_lift")
    private Boolean isBrandLift;

    /**
     * Сохраняем это поле только для outdoor и indoor креативов.
     * Если необходимо начать сохранять для других видео-креативов, необходимо добавить валидацию и перестать стирать
     * из модели это поле перед сохранением в базу
     */
    @JsonProperty("additional_data")
    private AdditionalData additionalData;

    @ApiModelProperty(
            value = "id креатива",
            required = true,
            name = "creative_id"
    )
    public long getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(long creativeId) {
        this.creativeId = creativeId;
    }

    @ApiModelProperty(
            value = "тип креатива",
            required = true,
            name = "creative_type"
    )
    public CreativeUploadType getCreativeType() {
        return creativeType;
    }

    public void setCreativeType(CreativeUploadType creativeType) {
        this.creativeType = creativeType;
    }

    @ApiModelProperty(
            value = "название креатива в BS",
            required = true,
            name = "creative_name"
    )
    public String getCreativeName() {
        return creativeName;
    }

    public void setCreativeName(String creativeName) {
        this.creativeName = creativeName;
    }

    @ApiModelProperty(
            value = "ссылка на превью креатива",
            required = true,
            name = "preview_url"
    )
    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    @ApiModelProperty(
            value = "ссылка на видео превью креатива",
            required = true,
            name = "live_preview_url"
    )
    public String getLivePreviewUrl() {
        return livePreviewUrl;
    }

    public void setLivePreviewUrl(String livePreviewUrl) {
        this.livePreviewUrl = livePreviewUrl;
    }

    @ApiModelProperty(
            value = "превью раскрывающегося блока у креатива",
            required = true,
            name = "expanded_preview_url"
    )
    public String getExpandedPreviewUrl() {
        return expandedPreviewUrl;
    }

    public void setExpandedPreviewUrl(String expandedPreviewUrl) {
        this.expandedPreviewUrl = expandedPreviewUrl;
    }

    @ApiModelProperty(
            value = "ширина креатива в px"
    )
    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    @ApiModelProperty(
            value = "высота креатива в px"
    )
    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    @ApiModelProperty(
            value = "Ид креатива где хранятся на него ресурсы"
    )
    public Long getStockCreativeId() {
        return stockCreativeId;
    }

    public void setStockCreativeId(Long stockCreativeId) {
        this.stockCreativeId = stockCreativeId;
    }

    @ApiModelProperty(
            value = "данные для передачи в модерацию",
            name = "moderation_info"
    )
    public ModerationInfo getModerationInfo() {
        return moderationInfo;
    }

    public void setModerationInfo(ModerationInfo moderationInfo) {
        this.moderationInfo = moderationInfo;
    }

    @ApiModelProperty(
            value = "Тип медиа из которого сформировали креатив (если применимо) - gif, jpg, png",
            name = "composed_from",
            allowableValues = "gif, jpg, png"
    )
    public CreativeUploadComposedFrom getComposedFrom() {
        return composedFrom;
    }

    public void setComposedFrom(CreativeUploadComposedFrom composedFrom) {
        this.composedFrom = composedFrom;
    }

    @ApiModelProperty(
            value = "ссылка на архив с креативом, для модерации чтобы его скачать и проверить",
            name = "archive_url"
    )
    public String getArchiveUrl() {
        return archiveUrl;
    }

    public void setArchiveUrl(String archiveUrl) {
        this.archiveUrl = archiveUrl;
    }

    @ApiModelProperty(
            value = "данные для передачи в БК",
            name = "yabs_data"
    )
    public YabsData getYabsData() {
        return yabsData;
    }

    public void setYabsData(YabsData yabsData) {
        this.yabsData = yabsData;
    }

    @ApiModelProperty(
            value = "длительность видео",
            name = "duration"
    )
    public Double getDuration() {
        return duration;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    @ApiModelProperty(
            value = "пресет креатива",
            name = "preset_id"
    )
    public Integer getPresetId() {
        return presetId;
    }

    public void setPresetId(Integer presetId) {
        this.presetId = presetId;
    }

    @ApiModelProperty(
            value = "дополнительные типоспецифичные данные",
            name = "additional_data"
    )
    public AdditionalData getAdditionalData() {
        return additionalData;
    }

    public void setAdditionalData(AdditionalData additionalData) {
        this.additionalData = additionalData;
    }

    @ApiModelProperty(
            value = "содержит ли packshot",
            name = "has_packshot"
    )
    public Boolean getHasPackshot() {
        return hasPackshot;
    }

    public void setHasPackshot(Boolean hasPackshot) {
        this.hasPackshot = hasPackshot;
    }

    @ApiModelProperty(
            value = "является ли адаптивным",
            name = "is_adaptive"
    )
    public Boolean getIsAdaptive() {
        return isAdaptive;
    }
    public void setIsAdaptive(Boolean isAdaptive) {
        this.isAdaptive = isAdaptive;
    }

    @ApiModelProperty(
            value = "признак брендлифтовости",
            name = "is_brand_lift"
    )
    public Boolean getIsBrandLift() {
        return isBrandLift;
    }

    public void setIsBrandLift(Boolean brandLift) {
        this.isBrandLift = brandLift;
    }

}
