package ru.yandex.direct.intapi.entity.display.canvas.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;

@ApiModel
public class CreativeUploadResult {
    @JsonProperty("creative_id")
    private final long creativeId;
    private final Status status;
    private final String message;

    private CreativeUploadResult(long creativeId, Status status, String message) {
        this.status = status;
        this.message = message;
        this.creativeId = creativeId;
    }

    public static CreativeUploadResult ok(long creativeId) {
        return ok(creativeId, "success");
    }

    public static CreativeUploadResult ok(long creativeId, String message, Object... params) {
        return new CreativeUploadResult(creativeId, CreativeUploadResult.Status.OK, String.format(message, params));
    }

    public static CreativeUploadResult error(long creativeId, String defects) {
        return new CreativeUploadResult(creativeId, CreativeUploadResult.Status.ERROR, defects);
    }

    public static CreativeUploadResult warning(long creativeId, String defects) {
        return new CreativeUploadResult(creativeId, Status.OK, defects);
    }

    @ApiModelProperty(
            value = "id креатива",
            required = true,
            name = "creative_id"
    )
    public long getCreativeId() {
        return creativeId;
    }

    @ApiModelProperty(
            value = "статус обработки креатива",
            required = true
    )
    public Status getStatus() {
        return status;
    }

    @ApiModelProperty(
            value = "статус обработки креатива: поясняющее сообщение",
            required = true
    )
    public String getMessage() {
        return message;
    }

    public String toString() {
        return new ToStringBuilder(this).
                append("creativeId", creativeId).
                append("status", status).
                append("message", message).
                toString();
    }

    public enum Status {
        OK,
        WARNING,
        ERROR
    }
}
