package ru.yandex.direct.intapi.entity.display.canvas.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;

public class GetUsedCreativesResponse {

    @JsonProperty("used_creatives")
    private final List<Long> usedCreatives;

    @JsonProperty("next_page_token")
    @JsonSerialize(using = ToStringSerializer.class)
    private final GetUsedCreativesPageToken nextPageToken;

    public GetUsedCreativesResponse(List<Long> usedCreatives, GetUsedCreativesPageToken nextPageToken) {
        this.usedCreatives = usedCreatives;
        this.nextPageToken = nextPageToken;
    }

    @ApiModelProperty(
            value = "список используемых креативов",
            required = true
    )
    public List<Long> getUsedCreatives() {
        return usedCreatives;
    }

    @ApiModelProperty(
            value = "токен следующей страницы",
            required = false
    )
    public GetUsedCreativesPageToken getNextPageToken() {
        return nextPageToken;
    }
}
