package ru.yandex.direct.intapi.entity.display.canvas.model;

import java.util.stream.Stream;

import com.fasterxml.jackson.annotation.JsonValue;


public enum GetUsedCreativesType {
    IMAGE("image"),
    VIDEO_ADDITION("videoAddition");

    private String value;

    GetUsedCreativesType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    public static GetUsedCreativesType getEnumByValue(String value) {
        return Stream.of(GetUsedCreativesType.values())
                .filter(val -> val.getValue().equals(value))
                .findFirst().orElse(null);
    }
}
