package ru.yandex.direct.intapi.entity.display.canvas.validation;

import org.springframework.stereotype.Service;

import ru.yandex.direct.intapi.entity.display.canvas.model.CreativeCampaignRequest;
import ru.yandex.direct.intapi.validation.IntApiDefect;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.intapi.validation.IntApiConstraints.notEmptyCollection;
import static ru.yandex.direct.intapi.validation.IntApiConstraints.notNull;

@Service
public class CreativeCampaignValidationService {

    public ValidationResult<CreativeCampaignRequest, IntApiDefect> validate(CreativeCampaignRequest request) {
        ItemValidationBuilder<CreativeCampaignRequest, IntApiDefect> v = ItemValidationBuilder.of(request);

        if (request == null) {
            v.check(notNull());
            return v.getResult();
        }

        v.list(request.getCreativeIds(), "creativeIds")
                .check(notNull())
                .check(notEmptyCollection())
                .checkEach(notNull());
        return v.getResult();
    }
}
