package ru.yandex.direct.intapi.entity.display.canvas.validation;

import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.creative.repository.CreativeConstants;
import ru.yandex.direct.intapi.entity.display.canvas.model.GetUsedCreativesRequest;
import ru.yandex.direct.intapi.entity.display.canvas.model.GetUsedCreativesSort;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.NumberConstraints.greaterThan;
import static ru.yandex.direct.validation.constraint.NumberConstraints.notGreaterThan;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;
import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;


@Service
public class DisplayCanvasUsedCreativeValidationService {

    public ValidationResult<GetUsedCreativesRequest, Defect> validate(GetUsedCreativesRequest request) {
        ItemValidationBuilder<GetUsedCreativesRequest, Defect> v = ItemValidationBuilder.of(request);
        v.item(request.getClientId(), "clientId")
                .check(notNull())
                .check(greaterThan(0L));
        v.item(request.getCreativeType(), "creativeType")
                .check(notNull());
        v.item(request.getLimit(), "limit")
                .check(notGreaterThan(CreativeConstants.GET_USED_CREATIVES_LIMIT), When.notNull());
        v.item(request.getNextPageToken(), "nextPageToken")
                .check(notBlank())
                .check(Constraint.fromPredicate(token -> token.split("-").length == 2, invalidValue()), When.isValid())
                .check(Constraint
                        .fromPredicate(token -> EnumUtils.isValidEnum(GetUsedCreativesSort.class, token.split("-")[0]),
                                invalidValue()), When.isValid())
                .check(Constraint.fromPredicate(token -> NumberUtils.isDigits(token.split("-")[1]), invalidValue()),
                        When.isValid());
        return v.getResult();
    }
}
