package ru.yandex.direct.intapi.entity.display.canvas.validation;

import java.util.List;

import org.springframework.stereotype.Service;

import ru.yandex.direct.intapi.entity.display.canvas.model.CreativeUploadData;
import ru.yandex.direct.intapi.validation.IntApiDefect;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.constraint.UniqueItemsConstraint;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.intapi.validation.IntApiConstraints.notEmptyCollection;
import static ru.yandex.direct.intapi.validation.IntApiConstraints.notNull;


@Service
public class UploadCreativesValidationService {

    public ValidationResult<List<CreativeUploadData>, IntApiDefect> validate(List<CreativeUploadData> creatives) {
        return ListValidationBuilder.<CreativeUploadData, IntApiDefect>of(creatives)
                .check(notNull())
                .check(notEmptyCollection())
                .checkEach(notNull())
                .checkEach(new UniqueItemsConstraint<>(CreativeUploadData::getCreativeId,
                        ConstraintErrors::duplicateCreativeId), When.isValid())
                .getResult();
    }
}
