package ru.yandex.direct.intapi.entity.feature.model;

import java.util.Set;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.feature.container.ClientRealFeature;
import ru.yandex.direct.core.entity.feature.container.FeaturesWithExpBoxes;
import ru.yandex.direct.core.entity.feature.model.Feature;

import static java.util.stream.Collectors.toSet;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class AbtInfoIntapi {
    @JsonProperty("features")
    private Set<String> features;
    @JsonProperty("boxes_crypted")
    private String boxesCrypted;
    @JsonProperty("boxes")
    private String boxes;

    public Set<String> getFeatures() {
        return features;
    }

    public AbtInfoIntapi withFeatures(Set<String> features) {
        this.features = features;
        return this;
    }

    public String getBoxesCrypted() {
        return boxesCrypted;
    }

    public AbtInfoIntapi withBoxesCryted(String boxesCryted) {
        this.boxesCrypted = boxesCryted;
        return this;
    }

    public String getBoxes() {
        return boxes;
    }

    public AbtInfoIntapi withBoxes(String boxes) {
        this.boxes = boxes;
        return this;
    }

    public static AbtInfoIntapi fromFeaturesWithExpBoxes(FeaturesWithExpBoxes featuresWithExpBoxes) {
        return new AbtInfoIntapi()
                .withBoxesCryted(featuresWithExpBoxes.getExpBoxesCrypted())
                .withBoxes(featuresWithExpBoxes.getExpBoxes())
                .withFeatures(featuresWithExpBoxes.getFeatures()
                        .stream()
                        .map(ClientRealFeature::getFeature).map(Feature::getFeatureTextId)
                        .collect(toSet()));
    }
}
