package ru.yandex.direct.intapi.entity.feature.model;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.dbutil.model.ClientId;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class ClientUidFeaturesIntapi {
    @JsonProperty("uids_features")
    private Map<Long, List<String>> uidsFeatures;
    @JsonProperty("client_ids_features")
    private Map<ClientId, List<String>> clientIdsFeatures;

    public Map<Long, List<String>> getUidsFeatures() {
        return uidsFeatures;
    }

    public ClientUidFeaturesIntapi withUidsFeatures(
            Map<Long, List<String>> uidsFeatures) {
        this.uidsFeatures = uidsFeatures;
        return this;
    }

    public Map<ClientId, List<String>> getClientIdsFeatures() {
        return clientIdsFeatures;
    }

    public ClientUidFeaturesIntapi withClientIdsFeatures(
            Map<ClientId, List<String>> clientIdsFeatures) {
        this.clientIdsFeatures = clientIdsFeatures;
        return this;
    }
}
