package ru.yandex.direct.intapi.entity.feature.model;

import com.fasterxml.jackson.annotation.JsonGetter;

import ru.yandex.direct.intapi.validation.model.IntapiSuccessResponse;

public abstract class FeatureResponse<T> extends IntapiSuccessResponse {
    private T result;

    @JsonGetter("result")
    public T getResult() {
        return result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public <R extends FeatureResponse<T>> R withResult(T result) {
        setResult(result);
        //noinspection unchecked
        return (R) this;
    }

}
