package ru.yandex.direct.intapi.entity.feature.presentation;

import ru.yandex.direct.core.entity.feature.service.validation.FeatureDefectTranslations;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.core.entity.feature.service.validation.FeatureDefectIds.CollectionDefectIds.FEATURE_IS_ALREADY_DISABLED_FOR_ROLE;
import static ru.yandex.direct.core.entity.feature.service.validation.FeatureDefectIds.CollectionDefectIds.FEATURE_IS_ALREADY_ENABLED_FOR_ROLE;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.intapiDefect;

public class FeatureDefectPresentations {

    private FeatureDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> featureDefectPresentationRegistry() {
        FeatureDefectTranslations translations = FeatureDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(FEATURE_IS_ALREADY_ENABLED_FOR_ROLE,
                        intapiDefect(translations.featureIsAlreadyEnabledForRole()))
                .register(FEATURE_IS_ALREADY_DISABLED_FOR_ROLE,
                        intapiDefect(translations.featureIsAlreadyDisabledForRole()))
                .build();
    }
}
