package ru.yandex.direct.intapi.entity.feature.service;

import java.util.Set;

public class AbtInfo {
    private final String boxesCrypted;
    private final String boxes;
    private final Set<String> features;

    private AbtInfo(String boxesCrypted, String boxes, Set<String> features) {
        this.boxesCrypted = boxesCrypted;
        this.boxes = boxes;
        this.features = features;
    }

    public String getBoxesCrypted() {
        return boxesCrypted;
    }

    public String getBoxes() {
        return boxes;
    }

    public Set<String> getFeatures() {
        return features;
    }

    public static class Builder {
        private String boxesCrypted;
        private String boxes;
        private Set<String> features;

        public Builder withBoxesCrypted(String boxesCrypted) {
            this.boxesCrypted = boxesCrypted;
            return this;
        }

        public Builder withBoxes(String boxes) {
            this.boxes = boxes;
            return this;
        }

        public Builder withFeatures(Set<String> features) {
            this.features = features;
            return this;
        }

        public AbtInfo build() {
            return new AbtInfo(boxesCrypted, boxes, features);
        }
    }
}
