package ru.yandex.direct.intapi.entity.freelancer.presentation;

import ru.yandex.direct.core.entity.freelancer.service.validation.AvatarsDefects;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.FeedbackDefects.FEEDBACK_ALREADY_EXIST;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.FeedbackDefects.FEEDBACK_NOT_FOUND;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.FeedbackDefects.INCORRECT_FEEDBACK_TEXT_SIZE;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.FeedbackDefects.OPERATOR_HAS_NO_PROJECT_WITH_FREELANCER;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.FeedbackDefects.OPERATOR_HAS_WRONG_ROLE;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.FeedbackDefects.OPERATOR_IS_NOT_CHIEF;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.ProjectsDefects.PROJECTS_ARE_ALREADY_EXIST;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.StatusDefects.TRANSITION_IS_NOT_AVAILABLE;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.VoidDefects.AGENCY_CLIENT_CANT_REQUEST_SERVICE;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.VoidDefects.CLIENT_CURRENCY_IS_NOT_CONVERTED;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.VoidDefects.CLIENT_HAS_WRONG_ROLE;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.VoidDefects.CLIENT_IS_ALREADY_FREELANCER;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.VoidDefects.CLIENT_NOT_FOUND;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.VoidDefects.DIRECT_CERTIFICATE_NOT_FOUND;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.VoidDefects.MUST_BE_CLIENT;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.VoidDefects.MUST_BE_FREELANCER;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.VoidDefects.MUST_HAVE_FREELANCER_CARD;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.VoidDefects.NAMES_MUST_BE_SAME_AS_CERT_NAMES;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.VoidDefects.PROJECT_NOT_FOUND;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.VoidDefects.SKILL_DOES_NOT_EXIST;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.VoidDefects.SOCIAL_CLIENTS_CANT_REQUEST_SERVICE;
import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.VoidDefects.USERS_COUNT_EXCEEDED;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;

public class FreelancerDefectPresentations {

    private FreelancerDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> freelancerDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(CLIENT_NOT_FOUND, defaultIntapiDefect())
                .register(MUST_BE_CLIENT, defaultIntapiDefect())
                .register(MUST_BE_FREELANCER, defaultIntapiDefect())
                .register(MUST_HAVE_FREELANCER_CARD, defaultIntapiDefect())
                .register(PROJECT_NOT_FOUND, defaultIntapiDefect())
                .register(CLIENT_IS_ALREADY_FREELANCER, defaultIntapiDefect())
                .register(CLIENT_HAS_WRONG_ROLE, defaultIntapiDefect())
                .register(SKILL_DOES_NOT_EXIST, defaultIntapiDefect())
                .register(CLIENT_CURRENCY_IS_NOT_CONVERTED, defaultIntapiDefect())
                .register(SOCIAL_CLIENTS_CANT_REQUEST_SERVICE, defaultIntapiDefect())
                .register(AGENCY_CLIENT_CANT_REQUEST_SERVICE, defaultIntapiDefect())
                .register(USERS_COUNT_EXCEEDED, defaultIntapiDefect())
                .register(PROJECTS_ARE_ALREADY_EXIST, defaultIntapiDefect())
                .register(TRANSITION_IS_NOT_AVAILABLE, defaultIntapiDefect())
                .register(FEEDBACK_NOT_FOUND, defaultIntapiDefect())
                .register(INCORRECT_FEEDBACK_TEXT_SIZE, defaultIntapiDefect())
                .register(OPERATOR_HAS_NO_PROJECT_WITH_FREELANCER, defaultIntapiDefect())
                .register(OPERATOR_HAS_WRONG_ROLE, defaultIntapiDefect())
                .register(OPERATOR_IS_NOT_CHIEF, defaultIntapiDefect())
                .register(FEEDBACK_ALREADY_EXIST, defaultIntapiDefect())
                .register(DIRECT_CERTIFICATE_NOT_FOUND, defaultIntapiDefect())
                .register(NAMES_MUST_BE_SAME_AS_CERT_NAMES, defaultIntapiDefect())
                .build();
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> avatarsDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(AvatarsDefects.AvatarsClientDefects.SERVER_CONNECTION_ERROR, defaultIntapiDefect())
                .register(AvatarsDefects.AvatarsClientDefects.UNKNOWN_ERROR, defaultIntapiDefect())
                .build();
    }
}
