package ru.yandex.direct.intapi.entity.geoproduct;

import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.core.MediaType;

import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.IntApiException;
import ru.yandex.direct.intapi.entity.geoproduct.model.TransferMoneyRequest;
import ru.yandex.direct.intapi.entity.geoproduct.model.TransferMoneyResponse;
import ru.yandex.direct.intapi.entity.geoproduct.model.WalletRestMoneyItem;
import ru.yandex.direct.intapi.entity.geoproduct.model.WalletRestMoneyResponse;
import ru.yandex.direct.intapi.entity.geoproduct.service.GeoProductTransferMoneyService;
import ru.yandex.direct.intapi.entity.geoproduct.service.GeoProductTransferMoneyValidationService;
import ru.yandex.direct.intapi.validation.kernel.ValidationResultConversionService;
import ru.yandex.direct.tvm.AllowServices;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.DIRECT_INTAPI_TEST;
import static ru.yandex.direct.tvm.TvmService.GEO_PRODUCT_PROD;
import static ru.yandex.direct.tvm.TvmService.GEO_PRODUCT_TEST;

@RestController
@RequestMapping("geoproduct")
@Api(tags = "geoproduct", value = "для нужд геопродукта")
@AllowServices(
        production = {GEO_PRODUCT_PROD},
        testing = {GEO_PRODUCT_TEST, DIRECT_DEVELOPER, DIRECT_INTAPI_TEST})
public class GeoProductController {
    private final GeoProductTransferMoneyService geoProductTransferMoneyService;
    private final GeoProductTransferMoneyValidationService geoProductValidationService;
    private final ValidationResultConversionService validationResultConversionService;

    @Autowired
    public GeoProductController(GeoProductTransferMoneyService geoProductTransferMoneyService,
            GeoProductTransferMoneyValidationService geoProductTransferMoneyValidationService,
            ValidationResultConversionService validationResultConversionService) {
        this.geoProductTransferMoneyService = geoProductTransferMoneyService;
        this.geoProductValidationService = geoProductTransferMoneyValidationService;
        this.validationResultConversionService = validationResultConversionService;
    }

    @POST
    @RequestMapping(path = "transfer_money",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON,
            produces = MediaType.APPLICATION_JSON
    )
    public TransferMoneyResponse transferMoney(
            @RequestBody TransferMoneyRequest transferMoneyRequest) {
        ValidationResult<TransferMoneyRequest, Defect> vr = geoProductValidationService.validate(transferMoneyRequest);
        if (vr.hasAnyErrors()) {
            throw new IntApiException(HttpStatus.BAD_REQUEST, new ErrorResponse(ErrorResponse.ErrorCode.BAD_PARAM,
                    validationResultConversionService.convertErrorsToString(vr)));
        }

        return geoProductTransferMoneyService.transferMoney(transferMoneyRequest);
    }

    @GET
    @RequestMapping(path = "wallet_rest_money",
            method = RequestMethod.GET,
            consumes = MediaType.APPLICATION_JSON,
            produces = MediaType.APPLICATION_JSON
    )
    public WalletRestMoneyResponse getWalletRestMoney(
            @RequestParam(value = "client_id", required = false) List<Long> clientIdList,
            @RequestParam(value = "wallet_id") List<Long> walletIdList) {
        List<WalletRestMoneyItem> walletRestMoneyItems = geoProductTransferMoneyService.getWalletsRestMoney(
                clientIdList, walletIdList);
        return new WalletRestMoneyResponse(walletRestMoneyItems);
    }

}
