package ru.yandex.direct.intapi.entity.geoproduct.model;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WalletRestMoneyItem {

    @JsonProperty("clientId")
    private Long clientId;

    @JsonProperty("accountId")
    private Long accountId;

    @JsonProperty("amount")
    private BigDecimal amount;

    @JsonProperty("amountWithNds")
    private BigDecimal amountWithNds;

    @JsonProperty("totalCashback")
    private BigDecimal totalCashback;

    @JsonProperty("totalCashbackWithoutNds")
    private BigDecimal totalCashbackWithoutNds;

    @JsonProperty("awaitingCashback")
    private BigDecimal awaitingCashback;

    @JsonProperty("awaitingCashbackWithoutNds")
    private BigDecimal awaitingCashbackWithoutNds;

    public Long getClientId() {
        return clientId;
    }

    public WalletRestMoneyItem withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Long getAccountId() {
        return accountId;
    }

    public WalletRestMoneyItem withAccountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public WalletRestMoneyItem withAmount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    public BigDecimal getAmountWithNds() {
        return amountWithNds;
    }

    public WalletRestMoneyItem withAmountWithNds(BigDecimal amountWithNds) {
        this.amountWithNds = amountWithNds;
        return this;
    }

    public BigDecimal getTotalCashback() {
        return totalCashback;
    }

    public WalletRestMoneyItem withTotalCashback(BigDecimal totalCashback) {
        this.totalCashback = totalCashback;
        return this;
    }

    public BigDecimal getTotalCashbackWithoutNds() {
        return totalCashbackWithoutNds;
    }

    public WalletRestMoneyItem withTotalCashbackWithoutNds(BigDecimal totalCashbackWithoutNds) {
        this.totalCashbackWithoutNds = totalCashbackWithoutNds;
        return this;
    }

    public BigDecimal getAwaitingCashback() {
        return awaitingCashback;
    }

    public WalletRestMoneyItem withAwaitingCashback(BigDecimal awaitingCashback) {
        this.awaitingCashback = awaitingCashback;
        return this;
    }

    public BigDecimal getAwaitingCashbackWithoutNds() {
        return awaitingCashbackWithoutNds;
    }

    public WalletRestMoneyItem withAwaitingCashbackWithoutNds(BigDecimal awaitingCashbackWithoutNds) {
        this.awaitingCashbackWithoutNds = awaitingCashbackWithoutNds;
        return this;
    }

    @Override
    public String toString() {
        return "AccountTransferAmount{" +
                "clientId=" + clientId +
                ", accountId=" + accountId +
                ", amount=" + amount +
                ", amountWithNds=" + amountWithNds +
                ", totalCashback=" + totalCashback +
                ", totalCashbackWithoutNds=" + totalCashbackWithoutNds +
                ", awaitingCashback=" + awaitingCashback +
                ", awaitingCashbackWithoutNds=" + awaitingCashbackWithoutNds +
                '}';
    }
}
