package ru.yandex.direct.intapi.entity.geosearch;

import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.geosearch.GeosearchClient;
import ru.yandex.direct.geosearch.model.GeoObject;
import ru.yandex.direct.geosearch.model.Lang;
import ru.yandex.direct.tvm.AllowServices;

import static ru.yandex.direct.tvm.TvmService.DIRECT_API_PROD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_API_TEST;
import static ru.yandex.direct.tvm.TvmService.DIRECT_AUTOTESTS;
import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.DIRECT_INTAPI_SANDBOX;
import static ru.yandex.direct.tvm.TvmService.DIRECT_INTAPI_SANDBOX_TEST;
import static ru.yandex.direct.tvm.TvmService.DIRECT_SCRIPTS_PROD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_SCRIPTS_TEST;
import static ru.yandex.direct.tvm.TvmService.DIRECT_WEB_PROD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_WEB_TEST;

@Controller
@RequestMapping(value = "geosearch", method = RequestMethod.GET,
        produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "Поиск указанного адреса с помощью Geosearch API")
@AllowServices(
        production = {DIRECT_WEB_PROD, DIRECT_SCRIPTS_PROD, DIRECT_API_PROD},
        testing = {DIRECT_WEB_TEST, DIRECT_SCRIPTS_TEST, DIRECT_API_TEST, DIRECT_AUTOTESTS, DIRECT_DEVELOPER},
        sandbox = {DIRECT_INTAPI_SANDBOX},
        sandboxTesting = {DIRECT_INTAPI_SANDBOX_TEST, DIRECT_AUTOTESTS, DIRECT_DEVELOPER})

public class GeosearchController {

    private GeosearchClient geosearchClient;

    @Autowired
    public GeosearchController(GeosearchClient geosearchClient) {
        this.geosearchClient = geosearchClient;
    }

    @ApiOperation(
            value = "getGeosearchAddress",
            httpMethod = "GET",
            nickname = "getGeosearchAddress"
    )

    @GetMapping(path = "address")
    @ResponseBody
    public List<GeoObject> getGeosearchAddress(
            @ApiParam(value = "текст запроса с адресом")
            @RequestParam(value = "text", required = true) String text,
            @ApiParam(value = "язык заппроса")
            @RequestParam(value = "lang", required = true) String lang) {

        final List<GeoObject> geoObjects = geosearchClient.searchAddress(text, Lang.valueOf(lang));
        return geoObjects;
    }

    @ApiOperation(
            value = "getGeosearchMetro",
            httpMethod = "GET",
            nickname = "getGeosearchMetro"
    )

    @GetMapping(path = "metro")
    @ResponseBody
    public List<GeoObject> getGeosearchMetro(
            @ApiParam(value = "текст запроса с адресом")
            @RequestParam(value = "text", required = true) String text,
            @ApiParam(value = "язык заппроса")
            @RequestParam(value = "lang", required = true) String lang) {

        final List<GeoObject> geoObjects = geosearchClient.searchMetro(text, Lang.valueOf(lang));
        return geoObjects;
    }
}
