package ru.yandex.direct.intapi.entity.grants.presentation;

import ru.yandex.direct.core.entity.grants.service.validation.GrantsDefectTranslations;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.core.entity.grants.service.validation.GrantsDefectIds.Gen.INCONSISTENT_STATE_ALLOW_EDIT_CAMPAIGN_AND_ALLOW_IMPORT_XLS;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.intapiDefect;

public class GrantsDefectPresentations {

    private GrantsDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> grantsDefectPresentationRegistry() {
        GrantsDefectTranslations translations = GrantsDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(INCONSISTENT_STATE_ALLOW_EDIT_CAMPAIGN_AND_ALLOW_IMPORT_XLS,
                        intapiDefect(translations.inconsistentStateAllowEditCampaignAndAllowImportXls()))
                .build();
    }
}
