package ru.yandex.direct.intapi.entity.idm.container;

/**
 * Информация о текущем запросе.
 * Содержит идентификаторы роли отданной последней в предыдущем запросе и ожидаемый размер возвращаемой страницы.
 */
public class PageInfo {
    public static final String ROLE_NAME = "last_role";
    public static final String CLIENT_ID = "last_client_id";
    public static final String MANAGER_UID = "last_manager_uid";
    public static final String SUPPORT_ID = "last_support_id";
    public static final String GROUP_ID = "last_group_id";
    public static final String LIMIT = "limit";

    private String roleName;
    private Integer rolePriority;
    private Long clientId;
    private Long managerUid;
    private Long supportId;
    private Integer groupId;
    private Integer recordsLimit;

    public String getRoleName() {
        return roleName;
    }

    public PageInfo withRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    public int getRolePriority() {
        return rolePriority;
    }

    public PageInfo withRolePriority(int rolePriority) {
        this.rolePriority = rolePriority;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public PageInfo withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Long getManagerUid() {
        return managerUid;
    }

    public PageInfo withManagerUid(Long managerUid) {
        this.managerUid = managerUid;
        return this;
    }

    public Long getSupportId() {
        return supportId;
    }

    public PageInfo withSupportId(Long supportId) {
        this.supportId = supportId;
        return this;
    }

    public Integer getGroupId() {
        return groupId;
    }

    public PageInfo withGroupId(Integer groupId) {
        this.groupId = groupId;
        return this;
    }

    public Integer getRecordsLimit() {
        return recordsLimit;
    }

    public PageInfo withRecordsLimit(Integer recordsLimit) {
        this.recordsLimit = recordsLimit;
        return this;
    }
}
