package ru.yandex.direct.intapi.entity.idm.controller;

import javax.ws.rs.GET;
import javax.ws.rs.core.MediaType;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.entity.idm.container.PageInfo;
import ru.yandex.direct.intapi.entity.idm.model.GetRolesResponse;
import ru.yandex.direct.intapi.entity.idm.service.IdmGetPagedRolesService;
import ru.yandex.direct.tvm.AllowServices;

import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.IDM_PROD;
import static ru.yandex.direct.tvm.TvmService.IDM_TEST;

@RestController
@RequestMapping(IdmRoleManagementController.CONTROLLER_PATH)
@AllowServices(production = {IDM_PROD}, testing = {IDM_TEST, DIRECT_DEVELOPER})
public class IdmRoleManagementController {
    static final String CONTROLLER_PATH = "idm";
    private static final String GET_ROLES_PATH = "get-roles";
    public static final String GET_ROLES_BASE_PATH = String.format("/%s/%s", CONTROLLER_PATH, GET_ROLES_PATH);

    private final IdmGetPagedRolesService idmGetPagedRolesService;

    @Autowired
    public IdmRoleManagementController(IdmGetPagedRolesService idmGetPagedRolesService) {
        this.idmGetPagedRolesService = idmGetPagedRolesService;
    }

    @GET
    @ApiOperation(
            value = "получить логины и роли директа",
            nickname = GET_ROLES_PATH,
            httpMethod = "GET"
    )
    @ApiResponses({
            @ApiResponse(code = 403, message = "Недостаточно прав для выполнения операции",
                    response = ErrorResponse.class),
            @ApiResponse(code = 400, message = "Некорректный запрос",
                    response = ErrorResponse.class)
    })
    @RequestMapping(path = GET_ROLES_PATH,
            method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON
    )
    public GetRolesResponse getRoles(@RequestParam(name = PageInfo.ROLE_NAME, required = false) String lastRole,
                                     @RequestParam(name = PageInfo.CLIENT_ID, required = false) Long lastClientId,
                                     @RequestParam(name = PageInfo.MANAGER_UID, required = false) Long lastManagerUid,
                                     @RequestParam(name = PageInfo.SUPPORT_ID, required = false) Long lastSupportId,
                                     @RequestParam(name = PageInfo.GROUP_ID, required = false) Integer lastGroupId,
                                     @RequestParam(name = PageInfo.LIMIT, required = false) Integer limit) {
        PageInfo pageInfo = new PageInfo()
                .withRoleName(lastRole)
                .withClientId(lastClientId)
                .withManagerUid(lastManagerUid)
                .withSupportId(lastSupportId)
                .withGroupId(lastGroupId)
                .withRecordsLimit(limit);
        return idmGetPagedRolesService.getRoles(pageInfo);
    }

}
