package ru.yandex.direct.intapi.entity.idm.converter;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.client.model.ClientPrimaryManager;
import ru.yandex.direct.core.entity.idm.model.IdmGroupRole;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.intapi.entity.idm.container.LastReturnedRoleInfo;
import ru.yandex.direct.intapi.entity.idm.model.GetRolesResponseItem;
import ru.yandex.direct.intapi.entity.idm.model.IdmGroupRoleName;
import ru.yandex.direct.intapi.entity.idm.model.IdmSupportForClientRole;
import ru.yandex.direct.intapi.entity.idm.model.IdmUserRole;

import static ru.yandex.direct.intapi.entity.idm.converter.IdmCommonNames.MAIN_MANAGER_ROLE_SLUG_NAME;
import static ru.yandex.direct.intapi.entity.idm.converter.IdmCommonNames.SLUG;
import static ru.yandex.direct.intapi.entity.idm.converter.IdmCommonNames.SUPPORT_FOR_CLIENT_ROLE_NAME;
import static ru.yandex.direct.utils.CommonUtils.nvl;

@ParametersAreNonnullByDefault
public class GetRolesResponseConverter {
    private GetRolesResponseConverter() {
    }

    public static GetRolesResponseItem toGetRolesResponseItem(IdmUserRole userRole) {
        return GetRolesResponseItem.getBuilder(SLUG, userRole.getRole().getTypedValue())
                .withDomainLogin(userRole.getDomainLogin())
                .withPassportLogin(userRole.getPassportLogin())
                .withInternalUid(userRole.getUid())
                .build();
    }

    public static GetRolesResponseItem toGetRolesResponseItem(IdmSupportForClientRole supportForClient) {
        return GetRolesResponseItem.getBuilder(SLUG, SUPPORT_FOR_CLIENT_ROLE_NAME)
                .withDomainLogin(supportForClient.getDomainLogin())
                .withPassportLogin(supportForClient.getPassportLogin())
                .withSupportId(supportForClient.getSupportClientId().asLong())
                .withClientId(supportForClient.getSubjectClientId())
                .build();
    }

    public static GetRolesResponseItem toGetRolesResponseItem(ClientPrimaryManager primaryManager) {
        return GetRolesResponseItem.getBuilder(SLUG, MAIN_MANAGER_ROLE_SLUG_NAME)
                .withClientId(primaryManager.getSubjectClientId())
                .withDomainLogin(primaryManager.getDomainLogin())
                .withPassportLogin(primaryManager.getPassportLogin())
                .withInternalUid(primaryManager.getPrimaryManagerUid())
                .build();
    }

    public static GetRolesResponseItem toGetRolesResponseItem(IdmGroupRole idmGroupRole) {
        return GetRolesResponseItem.getBuilder(SLUG, IdmGroupRoleName.MANAGER_FOR_CLIENT.getTypedValue())
                .withClientId(idmGroupRole.getClientId())
                .withGroupId(idmGroupRole.getIdmGroupId().intValue())
                .build();
    }

    public static GetRolesResponseItem toGetRolesResponseItem(LastReturnedRoleInfo lastRole, String defaultRoleName) {
        return GetRolesResponseItem.getBuilder(SLUG, nvl(lastRole.getRoleName(), defaultRoleName))
                .withClientId(ClientId.fromNullableLong(lastRole.getClientId()))
                .withInternalUid(lastRole.getManagerUid())
                .withSupportId(lastRole.getSupportId())
                .withGroupId(lastRole.getGroupId())
                .build();
    }

}
