package ru.yandex.direct.intapi.entity.idm.memberships.container;

/**
 * Информация о текущем запросе.
 * Содержит идентификаторы роли отданной последней в предыдущем запросе и ожидаемый размер возвращаемой страницы.
 */
public class MembershipsPageInfo {
    public static final String CLIENT_ID = "last_client_id";
    public static final String GROUP_ID = "last_group_id";
    public static final String LIMIT = "limit";

    private Long clientId;
    private Long groupId;
    private Integer recordsLimit;

    public Long getClientId() {
        return clientId;
    }

    public MembershipsPageInfo withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Long getGroupId() {
        return groupId;
    }

    public MembershipsPageInfo withGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    public Integer getRecordsLimit() {
        return recordsLimit;
    }

    public MembershipsPageInfo withRecordsLimit(Integer recordsLimit) {
        this.recordsLimit = recordsLimit;
        return this;
    }
}
