package ru.yandex.direct.intapi.entity.idm.memberships.controller;

import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.core.MediaType;

import com.fasterxml.jackson.core.type.TypeReference;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.entity.idm.memberships.container.MembershipsPageInfo;
import ru.yandex.direct.intapi.entity.idm.memberships.model.ChangeMembershipsResponse;
import ru.yandex.direct.intapi.entity.idm.memberships.model.GetMembershipsResponse;
import ru.yandex.direct.intapi.entity.idm.memberships.model.Membership;
import ru.yandex.direct.intapi.entity.idm.memberships.service.IdmMembershipsService;
import ru.yandex.direct.tvm.AllowServices;

import static ru.yandex.direct.intapi.entity.idm.memberships.controller.IdmMembershipsController.CONTROLLER_PATH;
import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.IDM_PROD;
import static ru.yandex.direct.tvm.TvmService.IDM_TEST;
import static ru.yandex.direct.utils.JsonUtils.fromJson;


@RestController
@RequestMapping(CONTROLLER_PATH)
@AllowServices(production = {IDM_PROD}, testing = {IDM_TEST, DIRECT_DEVELOPER})
public class IdmMembershipsController {
    static final String CONTROLLER_PATH = "idm";
    private static final String ADD_BATCH_MEMBERSHIPS = "add-batch-memberships";
    private static final String REMOVE_BATCH_MEMBERSHIPS = "remove-batch-memberships";
    private static final String GET_MEMBERSHIPS_PATH = "get-memberships";
    public static final String GET_MEMBERSHIPS_BASE_PATH =
            String.format("/%s/%s", CONTROLLER_PATH, GET_MEMBERSHIPS_PATH);

    private static final TypeReference<List<Membership>> MEMBERSHIP_LIST_TYPE = new TypeReference<>() {
    };

    private final IdmMembershipsService idmMembershipsService;

    @Autowired
    public IdmMembershipsController(IdmMembershipsService idmMembershipsService) {
        this.idmMembershipsService = idmMembershipsService;
    }

    @POST
    @ApiOperation(value = "добавить участников в группы", nickname = ADD_BATCH_MEMBERSHIPS, httpMethod = "POST")
    @ApiResponses({
            @ApiResponse(code = 403, message = "Недостаточно прав для выполнения операции",
                    response = ErrorResponse.class),
            @ApiResponse(code = 400, message = "Некорректный запрос", response = ErrorResponse.class)})
    @PostMapping(
            path = ADD_BATCH_MEMBERSHIPS,
            consumes = MediaType.APPLICATION_FORM_URLENCODED,
            produces = MediaType.APPLICATION_JSON
    )
    public ChangeMembershipsResponse addMemberships(@RequestParam("data") String membershipsString) {
        List<Membership> memberships = fromJson(membershipsString, MEMBERSHIP_LIST_TYPE);
        return idmMembershipsService.addMemberships(memberships);
    }

    @POST
    @ApiOperation(value = "удалить участников из групп", nickname = REMOVE_BATCH_MEMBERSHIPS, httpMethod = "POST")
    @ApiResponses({
            @ApiResponse(code = 403, message = "Недостаточно прав для выполнения операции",
                    response = ErrorResponse.class),
            @ApiResponse(code = 400, message = "Некорректный запрос", response = ErrorResponse.class)})
    @PostMapping(
            path = REMOVE_BATCH_MEMBERSHIPS,
            consumes = MediaType.APPLICATION_FORM_URLENCODED,
            produces = MediaType.APPLICATION_JSON
    )
    public ChangeMembershipsResponse removeMemberships(@RequestParam("data") String membershipsString) {
        List<Membership> memberships = fromJson(membershipsString, MEMBERSHIP_LIST_TYPE);
        return idmMembershipsService.removeMemberships(memberships);
    }

    @GET
    @ApiOperation(value = "Возвращает всех членов групп для всех групп", nickname = GET_MEMBERSHIPS_PATH, httpMethod
            = "GET")
    @ApiResponses({
            @ApiResponse(code = 403, message = "Недостаточно прав для выполнения операции",
                    response = ErrorResponse.class),
            @ApiResponse(code = 400, message = "Некорректный запрос", response = ErrorResponse.class)})
    @GetMapping(path = GET_MEMBERSHIPS_PATH, produces = MediaType.APPLICATION_JSON)
    public GetMembershipsResponse getMemberships(
            @RequestParam(name = MembershipsPageInfo.CLIENT_ID, required = false) Long lastClientId,
            @RequestParam(name = MembershipsPageInfo.GROUP_ID, required = false) Long lastGroupId,
            @RequestParam(name = MembershipsPageInfo.LIMIT, required = false) Integer limit) {
        MembershipsPageInfo pageInfo = new MembershipsPageInfo()
                .withClientId(lastClientId)
                .withGroupId(lastGroupId)
                .withRecordsLimit(limit);
        return idmMembershipsService.getMemberships(pageInfo);
    }

}
