package ru.yandex.direct.intapi.entity.idm.memberships.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;


public class GetMembershipsResponse {
    @JsonProperty("code")
    private Integer code;

    @JsonProperty("next-url")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String nextUrl;

    @JsonProperty("memberships")
    private List<Membership> memberships;

    public Integer getCode() {
        return code;
    }

    public GetMembershipsResponse withCode(Integer code) {
        this.code = code;
        return this;
    }

    public List<Membership> getMemberships() {
        return memberships;
    }

    public GetMembershipsResponse withMemberships(List<Membership> memberships) {
        this.memberships = memberships;
        return this;
    }

    public String getNextUrl() {
        return nextUrl;
    }

    public GetMembershipsResponse withNextUrl(String nextUrl) {
        this.nextUrl = nextUrl;
        return this;
    }

}
