package ru.yandex.direct.intapi.entity.idm.memberships.model;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Объект с описанием члена группы в idm
 */
public class Membership extends BaseMembership {
    /**
     * паспортный логин, т.е. логин под которым сотрудник заходит на yandex.ru
     */
    @JsonProperty("passport_login")
    private String passportLogin;

    @JsonProperty("passport_login")
    public String getPassportLogin() {
        return passportLogin;
    }

    @JsonProperty("passport_login")
    public void setPassportLogin(String passportLogin) {
        this.passportLogin = passportLogin;
    }

    public Membership withPassportLogin(String passportLogin) {
        setPassportLogin(passportLogin);
        return this;
    }

    public Membership withDomainLogin(String domainLogin) {
        setDomainLogin(domainLogin);
        return this;
    }

    public Membership withGroup(Integer groupId) {
        setGroupId(groupId);
        return this;
    }

}
