package ru.yandex.direct.intapi.entity.idm.memberships.model;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Объект с описанием ошибки операции над членством в группе
 */
public class MembershipError extends BaseMembership {
    /**
     * Описание ошибки произошедшей при измененнии членства сотрудника в группе.
     */
    @JsonProperty("error")
    private String errorMessage;

    @JsonProperty("error")
    public String getErrorMessage() {
        return errorMessage;
    }

    @JsonProperty("error")
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public MembershipError withPassportLogin(String passportLogin) {
        setErrorMessage(passportLogin);
        return this;
    }

    public MembershipError withDomainLogin(String domainLogin) {
        setDomainLogin(domainLogin);
        return this;
    }

    public MembershipError withGroup(Integer groupId) {
        setGroupId(groupId);
        return this;
    }

    public MembershipError withErrorMessage(String errorMessage) {
        setErrorMessage(errorMessage);
        return this;
    }

}
