package ru.yandex.direct.intapi.entity.idm.model;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonGetter;

import static java.util.Collections.singletonMap;
import static ru.yandex.direct.intapi.entity.idm.converter.IdmCommonNames.CLIENT_ID_SLUG;
import static ru.yandex.direct.intapi.entity.idm.converter.IdmCommonNames.PASSPORT_LOGIN;

public class AddRoleResponse extends IdmSuccessResponse {
    private final Map<String, String> data;

    private AddRoleResponse(Map<String, String> data) {
        this.data = data;
    }

    public static AddRoleResponse addRoleResponseWithPassportLogin(String passportLogin) {
        return new AddRoleResponse(singletonMap(PASSPORT_LOGIN, passportLogin));
    }

    public static AddRoleResponse addRoleResponseWithClientId(Long clientId) {
        return new AddRoleResponse(singletonMap(CLIENT_ID_SLUG, Long.toString(clientId)));
    }

    public static AddRoleResponse addRoleResponse(String passportLogin, Long clientId) {
        Map<String, String> data = Map.of(PASSPORT_LOGIN, passportLogin,
                CLIENT_ID_SLUG, Long.toString(clientId));
        return new AddRoleResponse(data);
    }

    @JsonGetter("data")
    public Map<String, String> getData() {
        return data;
    }
}
