package ru.yandex.direct.intapi.entity.idm.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;


@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetAllRolesResponse extends IdmSuccessResponse {
    private List<GetAllRolesResponseItem> users;
    private List<GetAllRolesResponseGroupsItem> groups;

    @JsonGetter("users")
    public List<GetAllRolesResponseItem> getUsers() {
        return users;
    }

    public GetAllRolesResponse withUsers(List<GetAllRolesResponseItem> users) {
        this.users = users;
        return this;
    }

    @JsonGetter("groups")
    public List<GetAllRolesResponseGroupsItem> getGroups() {
        return groups;
    }

    public GetAllRolesResponse withGroups(List<GetAllRolesResponseGroupsItem> groups) {
        this.groups = groups;
        return this;
    }
}
